<?php
session_start();
ob_start(); // Inicia o buffer de saída

include ('includes/yngred.php');

$log_check = $db->query("SELECT * FROM users WHERE id='1'");
$roe = $log_check->fetchArray();
$loggedinuser = $roe['username'];

if (!isset($_SESSION['name']) || $_SESSION['name'] != $loggedinuser) {
    header("Location: index.php");
    exit();
}

// Nome da tabela
$table_name = "dns";

// Arquivo atual
$base_file = "dns.php";

// Criar tabela se não existir
$db->exec("CREATE TABLE IF NOT EXISTS {$table_name} (
    id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, 
    title VARCHAR(100), 
    url TEXT
)");

// Buscar registros
$res = $db->query("SELECT * FROM {$table_name}");

// Atualização de registros
$update_id = filter_input(INPUT_GET, 'update', FILTER_VALIDATE_INT);
$rowU = null;

if ($update_id) {
    $resU = $db->query("SELECT * FROM {$table_name} WHERE id={$update_id}");
    $rowU = $resU ? $resU->fetchArray() : null;
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if (isset($_POST['submitU'])) {
        $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
        $title = filter_input(INPUT_POST, 'title', FILTER_SANITIZE_STRING);
        $url = filter_input(INPUT_POST, 'url', FILTER_SANITIZE_URL);
        
        if ($id && $title && $url) {
            $stmt = $db->prepare("UPDATE {$table_name} SET title=:title, url=:url WHERE id=:id");
            $stmt->bindValue(':title', $title, SQLITE3_TEXT);
            $stmt->bindValue(':url', $url, SQLITE3_TEXT);
            $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
            $stmt->execute();
        }
        
        header("Location: dns.php");
        exit();
    }

    if (isset($_POST['submit'])) {
        $title = filter_input(INPUT_POST, 'title', FILTER_SANITIZE_STRING);
        $url = filter_input(INPUT_POST, 'url', FILTER_SANITIZE_URL);

        if ($title && $url) {
            $stmt = $db->prepare("INSERT INTO {$table_name} (title, url) VALUES (:title, :url)");
            $stmt->bindValue(':title', $title, SQLITE3_TEXT);
            $stmt->bindValue(':url', $url, SQLITE3_TEXT);
            $stmt->execute();
        }

        header("Location: dns.php");
        exit();
    }
}

// Exclusão de registros
$delete_id = filter_input(INPUT_GET, 'delete', FILTER_VALIDATE_INT);
if ($delete_id) {
    $db->exec("DELETE FROM {$table_name} WHERE id={$delete_id}");
    header("Location: dns.php");
    exit();
}

ob_end_flush(); // Finaliza o buffer APENAS depois de todas as possíveis saídas do header
?>


<!-- Modal de Confirmação -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content" style="background-color: black;">
            <div class="modal-header">
                <h2 style="color: white;">Confirmar</h2>
            </div>
            <div class="modal-body" style="color: white;">
                Quer realmente apagar?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancelar</button>
                <a style="color: white;" class="btn btn-danger btn-ok">Apagar</a>
            </div>
        </div>
    </div>
</div>

<?php if (isset($_GET['create'])): ?>
<!-- Formulário de Criação -->
<div class="container text-center text-dark mt-5">
    <div class="row">
        <div class="col-lg-4 d-block mx-auto mt-5">
            <div class="card">
                <div class="card-body wow-bg" id="formBg">
                    <h3 class="colorboard">Adicionar DNS</h3>
                    <form method="post">
                        <div class="input-group mb-3">
                            <input type="text" class="form-control textbox-dg" name="title" placeholder="Title">
                        </div>
                        <div class="input-group mb-4">
                            <input type="text" class="form-control textbox-dg" name="url" placeholder="DNS">
                        </div>
                        <button type="submit" name="submit" class="btn btn-primary btn-block">Salvar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php elseif ($update_id && $rowU): ?>
<!-- Formulário de Edição -->
<div class="container text-center text-dark mt-5">
    <div class="row">
        <div class="col-lg-4 d-block mx-auto mt-5">
            <div class="card">
                <div class="card-body wow-bg" id="formBg">
                    <h3 class="colorboard">Editar DNS</h3>
                    <form method="post">
                        <input type="hidden" name="id" value="<?= htmlspecialchars($update_id) ?>">
                        <div class="input-group mb-3">
                            <input type="text" class="form-control textbox-dg" name="title" value="<?= htmlspecialchars($rowU['title']) ?>">
                        </div>
                        <div class="input-group mb-4">
                            <input type="text" class="form-control textbox-dg" name="url" value="<?= htmlspecialchars($rowU['url']) ?>">
                        </div>
                        <button type="submit" name="submitU" class="btn btn-primary btn-block">Salvar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php else: ?>
<!-- Tabela de Registros -->
<div class="col-md-12 mx-auto">
    <center>
        <h2 class="colorboard">Adicionar DNS</h2>
        <a href="<?= $base_file ?>?create" class="btn btn-primary">Novo DNS</a>
    </center>
    <br>
    <div class="table-responsive">
        <table class="table table-striped table-sm">
            <thead style="color:white!important">
                <tr>
                    <th>Index</th>
                    <th>Title</th>
                    <th>DNS</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $res->fetchArray()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['id']) ?></td>
                        <td><?= htmlspecialchars($row['title']) ?></td>
                        <td><?= htmlspecialchars($row['url']) ?></td>
                        <td>
                            <a class="btn btn-info btn-ok" href="<?= $base_file ?>?update=<?= $row['id'] ?>">
                                <i class="fa fa-pencil-square-o"></i>
                            </a>
                            &nbsp;&nbsp;&nbsp;
                            <a class="btn btn-danger btn-ok" href="#" data-href="<?= $base_file ?>?delete=<?= $row['id'] ?>" data-toggle="modal" data-target="#confirm-delete">
                                <i class="fa fa-trash-o"></i>
                            </a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

<?php include ('includes/footer.php'); ?>

</body>
</html>
