<?php
session_start();
ob_start(); // Inicia o buffer de saída

include ('includes/yngred.php');

// Verifica usuário logado
$log_check = $db->query("SELECT * FROM users WHERE id='1'");
$roe = $log_check->fetchArray();
$loggedinuser = $roe['username'];

if (!isset($_SESSION['name']) || $_SESSION['name'] != $loggedinuser) {
    header("Location: index.php");
    exit();
}

$table_name = "adds";
$base_file = basename($_SERVER["SCRIPT_NAME"]);

// Criar tabela se não existir
$db->exec("CREATE TABLE IF NOT EXISTS {$table_name} (
    id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
    title VARCHAR(100)
)");

// Verifica se a coluna `path` existe, se não, adiciona
$columns_check = $db->query("PRAGMA table_info({$table_name})");
$columns = [];
while ($column = $columns_check->fetchArray(SQLITE3_ASSOC)) {
    $columns[] = $column['name'];
}
if (!in_array('path', $columns)) {
    $db->exec("ALTER TABLE {$table_name} ADD COLUMN path TEXT");
}

// Processa a inserção
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['submit'])) {
    $title = $db->escapeString($_POST['title']);
    $path = $db->escapeString($_POST['path']);
    
    $query = "INSERT INTO {$table_name} (title, path) VALUES ('$title', '$path')";
    if ($db->exec($query)) {
        header("Location: {$base_file}");
        exit();
    } else {
        echo "<script>alert('Erro ao inserir!');</script>";
    }
}

// Processa a exclusão
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $db->exec("DELETE FROM {$table_name} WHERE id = $id");
    header("Location: {$base_file}");
    exit();
}

// Busca registros
$res = $db->query("SELECT * FROM {$table_name}");

ob_end_flush(); // Finaliza o buffer após os redirecionamentos
?>

<div class="container text-center mt-5">
    <h2>Imagens do Anúncio</h2>
    <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#addModal">Nova Imagem</a>
    <br><br>
    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Título</th>
                    <th>Imagem</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $res->fetchArray()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['title']) ?></td>
                        <td><img src="<?= htmlspecialchars($row['path']) ?>" width="75px" height="75px" alt="Imagem"></td>
                        <td>
                            <a href="#" class="btn btn-danger delete-btn" data-id="<?= $row['id'] ?>" data-toggle="modal" data-target="#confirm-delete">Excluir</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal de Adição -->
<div class="modal fade" id="addModal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2>Adicionar Imagem</h2>
            </div>
            <div class="modal-body">
                <form method="post">
                    <div class="form-group">
                        <label for="title">Título</label>
                        <input class="form-control" name="title" type="text" required />
                    </div>
                    <div class="form-group">
                        <label for="path">Imagem</label>
                        <input class="form-control" name="path" type="text" required />
                    </div>
                    <button class="btn btn-info" name="submit" type="submit">Salvar</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Confirmação para Deletar -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4>Confirmar Exclusão</h4>
            </div>
            <div class="modal-body">
                Tem certeza de que deseja excluir esta imagem?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <a href="#" class="btn btn-danger btn-ok">Excluir</a>
            </div>
        </div>
    </div>
</div>

<!-- Script para modal de confirmação -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    var confirmDeleteModal = document.getElementById("confirm-delete");
    var deleteButtons = document.querySelectorAll(".delete-btn");
    var deleteLink = confirmDeleteModal.querySelector(".btn-ok");

    deleteButtons.forEach(function(button) {
        button.addEventListener("click", function() {
            var id = this.getAttribute("data-id");
            deleteLink.href = "<?= $base_file ?>?delete=" + id;
        });
    });
});
</script>

<?php include ('includes/footer.php'); ?>
